<?php
namespace memberpress\courses\controllers\admin;

if(!defined('ABSPATH')) {die('You are not allowed to call this page directly.');}

use memberpress\courses as base;
use memberpress\courses\lib as lib;

class Options extends lib\BaseCtrl {
  public function load_hooks() {
    add_action('mpcs_admin_general_options', array($this, 'general'));
    add_action('wp_ajax_logo_uploader', array($this, 'dnd_logo_uploader'));
  }

  public function general($options) {
    \MeprView::render('/admin/options/courses_general', get_defined_vars());
  }

// handle uploaded file here
function dnd_logo_uploader (){

  check_ajax_referer('photo-upload');

  // you can use WP's wp_handle_upload() function:
  $file = $_FILES['async-upload'];
  $status = wp_handle_upload($file, array('test_form'=>true, 'action' => 'logo_uploader'));
  $id = wp_insert_attachment( array(
    'post_mime_type' => $status['type'],
    'post_title' => preg_replace('/\.[^.]+$/', '', basename($file['name'])),
    'post_content' => '',
    'post_status' => 'inherit'
  ), $status['file']);

  // and output the results or something...
  $response = array(
    'url' => $status['url'],
    'id' => $id,
  );

  echo json_encode($response);
  exit;
}



}
